<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class PropertyTypeSeeder extends Seeder
{
    public function run(): void
    {
        $propertyTypes = [
            'Residential Plot',
            'Commercial Plot',
            'Apartment',
            'House',
            'Villa',
            'Farm House',
            'Office Space',
            'Shop',
            'Warehouse',
            'Penthouse',
        ];

        foreach ($propertyTypes as $type) {
            DB::table('property_types')->insert([
                'title' => $type,
                'description' => 'Sample property type for ' . $type,
                'reference_no' => 'REF-' . Str::random(8),
                'created_by' => 1,
                'updated_by' => 1,
                'source_ip' => '127.0.0.1',
                'source_mac' => '00:00:00:00:00:00',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}