<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class PropertySeeder extends Seeder
{
    public function run(): void
    {
        $propertyTypes = DB::table('property_types')->pluck('id')->toArray();
        $projects = DB::table('projects')->pluck('id')->toArray();
        
        for ($i = 1; $i <= 30; $i++) {
            DB::table('properties')->insert([
                'entry_date' => now()->subDays(rand(1, 365)),
                'property_type_id' => $propertyTypes[array_rand($propertyTypes)],
                'project_id' => $projects[array_rand($projects)],
                'sector_title' => 'Sector ' . chr(65 + rand(0, 25)),
                'property_no' => 'P-' . str_pad($i, 4, '0', STR_PAD_LEFT),
                'title' => 'Property ' . $i,
                'is_price_negotiable' => rand(0, 1),
                'booking_no' => 'Un Booked',
                'area' => rand(500, 5000) + (rand(0, 99) / 100),
                'price' => rand(1000000, 50000000),
                'attribuites' => 'feature1,feature2,feature3',
                'description' => 'Sample property ' . $i,
                'reference_no' => 'REF-' . Str::random(8),
                'created_by' => 1,
                'updated_by' => 1,
                'source_ip' => '127.0.0.1',
                'source_mac' => '00:00:00:00:00:00',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}