<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class LandloardPaymentSeeder extends Seeder
{
    public function run(): void
    {
        $landloards = DB::table('landloards')->pluck('id')->toArray();
        
        for ($i = 1; $i <= 30; $i++) {
            DB::table('landloard_payments')->insert([
                'landloard_id' => $landloards[array_rand($landloards)],
                'payment_date' => now()->subDays(rand(1, 365)),
                'amount_paid' => rand(100000, 1000000),
                'payment_method' => ['cash', 'bank_transfer', 'cheque', 'online_payment'][array_rand(['cash', 'bank_transfer', 'cheque', 'online_payment'])],
                'transaction_reference' => 'LP-TXN-' . str_pad($i, 6, '0', STR_PAD_LEFT),
                'description' => 'Payment ' . $i . ' to landloard',
                'reference_no' => 'REF-' . Str::random(8),
                'created_by' => 1,
                'updated_by' => 1,
                'source_ip' => '127.0.0.1',
                'source_mac' => '00:00:00:00:00:00',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}