<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class LandloardPaymentScheduleSeeder extends Seeder
{
    public function run(): void
    {
        $landloards = DB::table('landloards')->pluck('id')->toArray();
        
        foreach ($landloards as $landloardId) {
            $scheduleCount = rand(5, 12);
            
            for ($i = 1; $i <= $scheduleCount; $i++) {
                $dueDate = now()->addMonths($i);
                $status = 'pending';
                $amountPaid = 0;
                $paidAt = null;
                
                // Randomly mark some schedules as paid
                if (rand(0, 1) && $i < $scheduleCount / 2) {
                    $status = 'paid';
                    $amountPaid = rand(100000, 1000000);
                    $paidAt = $dueDate->subDays(rand(1, 10));
                } elseif ($dueDate < now()) {
                    $status = 'overdue';
                }
                
                DB::table('landloard_payment_schedule')->insert([
                    'landloard_id' => $landloardId,
                    'manual_number' => $i,
                    'schedule_number' => $i,
                    'session' => '2023-24',
                    'installment_type' => ['monthly', 'quarterly', 'yearly', 'custom'][array_rand(['monthly', 'quarterly', 'yearly', 'custom'])],
                    'due_date' => $dueDate,
                    'reminder_date' => $dueDate->subDays(7),
                    'amount' => rand(100000, 1000000),
                    'amount_paid' => $amountPaid,
                    'paid_at' => $paidAt,
                    'status' => $status,
                    'description' => 'Payment schedule ' . $i . ' for landloard ' . $landloardId,
                    'reference_no' => 'REF-' . Str::random(8),
                    'created_by' => 1,
                    'updated_by' => 1,
                    'source_ip' => '127.0.0.1',
                    'source_mac' => '00:00:00:00:00:00',
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }
}