<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class CustomerSeeder extends Seeder
{
    public function run(): void
    {
        $customers = [
            ['name' => 'Muhammad Ali', 'cnic' => '3520212345681', 'phone' => '03101234567', 'email' => 'muhammad.ali@email.com'],
            ['name' => 'Fatima Zahra', 'cnic' => '3520212345682', 'phone' => '03101234568', 'email' => 'fatima.zahra@email.com'],
            ['name' => 'Ahmed Hassan', 'cnic' => '3520212345683', 'phone' => '03101234569', 'email' => 'ahmed.hassan@email.com'],
            ['name' => 'Ayesha Khan', 'cnic' => '3520212345684', 'phone' => '03101234570', 'email' => 'ayesha.khan@email.com'],
            ['name' => 'Bilal Ahmed', 'cnic' => '3520212345685', 'phone' => '03101234571', 'email' => 'bilal.ahmed@email.com'],
            ['name' => 'Sara Ali', 'cnic' => '3520212345686', 'phone' => '03101234572', 'email' => 'sara.ali@email.com'],
            ['name' => 'Usman Malik', 'cnic' => '3520212345687', 'phone' => '03101234573', 'email' => 'usman.malik@email.com'],
            ['name' => 'Zainab Raza', 'cnic' => '3520212345688', 'phone' => '03101234574', 'email' => 'zainab.raz@email.com'],
            ['name' => 'Hamza Siddiqui', 'cnic' => '3520212345689', 'phone' => '03101234575', 'email' => 'hamza.siddiqui@email.com'],
            ['name' => 'Mariam Yousuf', 'cnic' => '3520212345690', 'phone' => '03101234576', 'email' => 'mariam.yousuf@email.com'],
        ];

        foreach ($customers as $customer) {
            DB::table('customers')->insert([
                'name' => $customer['name'],
                'cnic' => $customer['cnic'],
                'passport' => rand(100000000, 999999999),
                'dob' => now()->subYears(rand(25, 60))->format('Y-m-d'),
                'phone' => $customer['phone'],
                'email' => $customer['email'],
                'address' => 'Sample address for ' . $customer['name'],
                'description' => 'Sample customer for ' . $customer['name'],
                'reference_no' => 'REF-' . Str::random(8),
                'created_by' => 1,
                'updated_by' => 1,
                'source_ip' => '127.0.0.1',
                'source_mac' => '00:00:00:00:00:00',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}