<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class CustomerPaymentSeeder extends Seeder
{
    public function run(): void
    {
        $bookings = DB::table('bookings')->pluck('id')->toArray();
        $customers = DB::table('customers')->pluck('id')->toArray();
        
        for ($i = 1; $i <= 50; $i++) {
            $bookingId = $bookings[array_rand($bookings)];
            $booking = DB::table('bookings')->where('id', $bookingId)->first();
            
            DB::table('customer_payments')->insert([
                'booking_id' => $bookingId,
                'customer_id' => $booking->customer_id,
                'payment_date' => now()->subDays(rand(1, 365)),
                'amount' => rand(50000, 500000),
                'payment_method' => ['cash', 'bank_transfer', 'cheque', 'online_payment'][array_rand(['cash', 'bank_transfer', 'cheque', 'online_payment'])],
                'transaction_reference' => 'TXN-' . str_pad($i, 6, '0', STR_PAD_LEFT),
                'description' => 'Payment ' . $i . ' for booking ' . $bookingId,
                'reference_no' => 'REF-' . Str::random(8),
                'created_by' => 1,
                'updated_by' => 1,
                'source_ip' => '127.0.0.1',
                'source_mac' => '00:00:00:00:00:00',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}