<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InstallmentPlan extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'property_id', 'customer_id', 'total_price', 'down_payment',
        'total_installments', 'installment_amount', 'start_date',
        'created_by', 'updated_by', 'source_ip', 'source_mac'
    ];

    public function property()
    {
        return $this->belongsTo(Property::class);
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function installments()
    {
        return $this->hasMany(Installment::class);
    }
}
