<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Installment extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'installment_plan_id', 'installment_number', 'due_date',
        'amount', 'amount_paid', 'paid_at', 'status',
        'created_by', 'updated_by', 'source_ip', 'source_mac'
    ];

    public function plan()
    {
        return $this->belongsTo(InstallmentPlan::class, 'installment_plan_id');
    }
}
