<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HasAuditFields;

class Customer extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'name', 'cnic', 'phone', 'email', 'address',
        'created_by', 'updated_by', 'source_ip', 'source_mac'
    ];

    public function installmentPlans()
    {
        return $this->hasMany(InstallmentPlan::class);
    }
}
