<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreBookingRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'property_id' => 'required|exists:properties,id',
            'customer_id' => 'required|exists:customers,id',
            'date' => 'nullable|date',
            'manual_booking_no' => 'nullable|string|max:255',
            'booking_no' => 'nullable|integer',
            'from_bvn_no' => 'nullable|string|max:255',
            'salesman' => 'nullable|string|max:255',
            'salesman_commission' => 'numeric|min:0',
            'dealer' => 'nullable|string|max:255',
            'next_to_kin' => 'nullable|string|max:255',
            'status' => 'nullable|string|in:active,cancelled,completed',
            'is_verified' => 'nullable|boolean',
            'measurement_charges' => 'required|numeric|min:0',
            'total_price' => 'required|numeric|min:0',
            'down_payment' => 'required|numeric|min:0',
            'installment_amount' => 'required|numeric|min:0',
            'start_date' => 'required|date',
            'description' => 'nullable|string',
            'reference_no' => 'nullable|string|max:255',
        ];
    }
}