<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BookingResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'date' => $this->date,
            'manual_booking_no' => $this->manual_booking_no,
            'booking_no' => $this->booking_no,
            'from_bvn_no' => $this->from_bvn_no,
            'salesman' => $this->salesman,
            'salesman_commission' => $this->salesman_commission,
            'dealer' => $this->dealer,
            'next_to_kin' => $this->next_to_kin,
            'status' => $this->status,
            'is_verified' => $this->is_verified,
            'measurement_charges' => $this->measurement_charges,
            'total_price' => $this->total_price,
            'down_payment' => $this->down_payment,
            'installment_amount' => $this->installment_amount,
            'start_date' => $this->start_date,
            'property' => new PropertyResource($this->whenLoaded('property')),
            'customer' => new CustomerResource($this->whenLoaded('customer')),
            'created_at' => $this->created_at->toDateTimeString(),
            'updated_at' => $this->updated_at->toDateTimeString(),
        ];
    }
}