<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateProjectRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => [
                'required',
                'string',
                'max:255',
                // The name must be unique, but we ignore the current project's ID
                Rule::unique('projects')->ignore($this->project->id),
            ],
            'type' => 'required|string',
            'entry_date' => 'nullable|date',
            'manual_no' => 'nullable|string|max:255',
            'known_as' => 'nullable|string|max:255',
            'landloard_id' => 'nullable|exists:landloards,id',
            'land_cost' => 'nullable|numeric|min:0',
            'address' => 'nullable|string',
            'completion_year' => 'nullable|integer|digits:4|min:1900|',
            'square_feet_per_marla' => 'nullable|integer|min:0',
            'current_phase' => 'nullable|string',
        ];
    }
}