<?php

namespace App\Http\Controllers\Api;

// No longer need to import the base Controller
use App\Http\Requests\StoreLandloardRequest;
use App\Http\Requests\UpdateLandloardRequest;
use App\Http\Resources\LandloardResource;
use App\Models\Landloard;
use Illuminate\Http\Request;

// Extend BaseApiController instead of Controller
class LandloardController extends BaseApiController
{
    public function index()
    {
        $landloards = Landloard::get();
        // The success() method will handle the response format
        return $this->success($landloards, 'Landloards retrieved successfully.');
    }

    public function store(StoreLandloardRequest $request)
    {
        $landloard = Landloard::create($request->validated());
        return $this->success(new LandloardResource($landloard), 'Landloard created successfully.', 201);
    }

    public function show(Landloard $landloard)
    {
        return $this->success(new LandloardResource($landloard), 'Landloard retrieved successfully.');
    }

    public function update(UpdateLandloardRequest $request, Landloard $landloard)
    {
        $landloard->update($request->validated());
        return $this->success(new LandloardResource($landloard), 'Landloard updated successfully.');
    }

    public function destroy(Landloard $landloard)
    {
        $landloard->delete();
        // A 204 response is standard for deletion, but you can also return a success message
        return response()->json(null, 204);
        // Or, for consistency:
        // return $this->success(null, 'Landloard deleted successfully.', 204);
    }
}