<?php

namespace App\Http\Controllers\Api;

use app\Http\Requests\StoreBookingRequest;
use app\Http\Requests\UpdateBookingRequest;
use app\Http\Resources\BookingResource;
use App\Models\Booking;
use Illuminate\Http\Request;

class BookingController extends BaseApiController
{
    public function index()
    {
        $bookings = Booking::with(['property', 'customer'])->latest()->paginate(10);
        return $this->success($bookings, 'Bookings retrieved successfully.');
    }

    public function store(StoreBookingRequest $request)
    {
        $booking = Booking::create($request->validated());
        return $this->success(new BookingResource($booking), 'Booking created successfully.', 201);
    }

    public function show(Booking $booking)
    {
        $booking->load(['property', 'customer']);
        return $this->success(new BookingResource($booking), 'Booking retrieved successfully.');
    }

    public function update(UpdateBookingRequest $request, Booking $booking)
    {
        $booking->update($request->validated());
        $booking->load(['property', 'customer']);
        return $this->success(new BookingResource($booking), 'Booking updated successfully.');
    }

    public function destroy(Booking $booking)
    {
        $booking->delete();
        return response()->json(null, 204);
    }
}